// IEView.cpp : CIEView NX̓̒`s܂B
//IE\EBhEɊւNX

#include "stdafx.h"

#include "IB.h"
#include "IBDoc.h"
#include "IEView.h"
#include "ChildFrm.h"
#include "InteractionToolView.h"

#include <afxctl.h>
#include <atlbase.h>
#include <exdispid.h>
#include <mshtml.h>
#include <mshtmdid.h>
#include <unknwn.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//
// CIEView::CHTMLElement
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIEView::CHTMLElement::CHTMLElement( CIEView* pBrowser, IDispatch* pDisp ) : m_pBrowser( pBrowser ), m_Type( INVALID ), m_Id(), m_dwConCookie( NULL ), m_pDisp( pDisp ), m_IsCon( false )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIEView::CHTMLElement::~CHTMLElement()
{
}

//
// ֐ : 
// @  \ : HTML̃^O^Cvo
//    : tag(Gg)
// ߂l : ELEMENT_TYPE(^O(Gg)̃^Cv)
//
ELEMENT_TYPE CIEView::CHTMLElement::GetType( CString& tag )
{
	//^Õ^Cvo
	//AINPUTHTMLȊOƂINVALIDƂ
	if( !strcmp( "IMG", tag ) )
		return INVALID;
	else if( tag == "A" )
		return INVALID;
	else if( tag == "DIV" )
		return INVALID;
	else if( tag == "SELECT" )
		return INVALID;
	else if( tag == "BUTTON" )
		return INVALID;
	else if( tag == "INPUT" )
		return INPUT;
	else if( tag == "TEXTAREA" )
		return INVALID;
	else if( tag=="HTML" )
		return ELEMENT;
	else 
		return INVALID;
	/*
	if( !strcmp( "IMG", tag ) )
		return IMG;
	else if( tag == "A" )
		return ANCHOR;
	else if( tag == "DIV" )
		return ELEMENT;
	else if( tag == "SELECT" )
		return SELECT;
	else if( tag == "BUTTON" )
		return BUTTON;
	else if( tag == "INPUT" )
		return INPUT;
	else if( tag == "TEXTAREA" )
		return TEXTAREA;
	else if( tag=="HTML" )
		return INVALID;
	else 
		return INVALID;
	*/
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
BOOL CIEView::CHTMLElement::Connect()
{
	HRESULT hr;
	IHTMLElement* pElem;
	hr = m_pDisp->QueryInterface( IID_IHTMLElement, (void**)&pElem );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	BSTR tag;
	CString strTag;
	pElem->get_tagName( &tag );
	strTag = tag;
	m_Type = GetType( strTag );

	switch( m_Type )
	{

	case ELEMENT :
		if( !AfxConnectionAdvise( pElem, DIID_HTMLElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
		{
			return FALSE;
		}
		break;

	case IMG :
		IHTMLImgElement* pImgElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLImgElement, (void**)&pImgElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionAdvise( pImgElem, DIID_HTMLImgEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
			{
				pImgElem->Release();
				break;
			}
		}
		return FALSE;

	case ANCHOR :
		IHTMLAnchorElement *pAnchElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLAnchorElement, (void**)&pAnchElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionAdvise( pAnchElem, DIID_HTMLAnchorEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
			{
				pAnchElem->Release();
				break;
			}
		}
		return FALSE;

	case SELECT :
		IHTMLSelectElement *pSelElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLSelectElement, (void**)&pSelElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionAdvise( pSelElem, DIID_HTMLSelectElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
			{
				pSelElem->Release();
				break;
			}
		}
		return FALSE;
		
	case BUTTON :
		IHTMLButtonElement *pBtnElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLButtonElement, (void**)&pBtnElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionAdvise( pBtnElem, DIID_HTMLButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
			{
				pBtnElem->Release();
				break;
			}
		}
		return FALSE;

	case TEXTAREA :
		IHTMLTextAreaElement *pTxtElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLTextAreaElement, (void**)&pTxtElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionAdvise( pTxtElem, DIID_HTMLTextContainerEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
			{
				pTxtElem->Release();
				break;
			}
		}
		return FALSE;

	case INPUT :
		MSHTML::IHTMLInputElement *pIptElem;
		hr = m_pDisp->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString strType;			
			pIptElem->get_type( &bstrType );
			strType = bstrType;
			pIptElem->Release();

			if( !strcmp( strType, "text" ) )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionAdvise( pITxtElem, DIID_HTMLInputTextElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
					{
						pITxtElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "button" ) )
			{
				IHTMLInputButtonElement *pIBtnElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIBtnElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionAdvise( pIBtnElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
					{
						pIBtnElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "radio" ) )
			{
				IHTMLInputButtonElement *pIRdoElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIRdoElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionAdvise( pIRdoElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
					{
						pIRdoElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "checkbox" ) )
			{
				IHTMLInputButtonElement *pIChkElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIChkElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionAdvise( pIChkElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
					{
						pIChkElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "password" ) )
			{
				IHTMLInputButtonElement *pIPswElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputTextElement, (void**)&pIPswElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionAdvise( pIPswElem, DIID_HTMLInputTextElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
					{
						pIPswElem->Release();
						break;
					}
				}
				return FALSE;
			}
			else
			{
				return FALSE;
			}
		}
		return FALSE;

	default:
		return FALSE;
	}


	BSTR bstr_id;
	pElem->get_id( &bstr_id );
	m_Id = bstr_id;

	m_IsCon = true;

	pElem->Release();

	return TRUE;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
BOOL CIEView::CHTMLElement::Disconnect()
{
	if( !m_IsCon ){ return FALSE; }

	HRESULT hr;
	switch( m_Type )
	{
	case ELEMENT :
		IHTMLElement* pElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLElement, (void**)&pElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionUnadvise( pElem, DIID_HTMLElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
			{
				pElem->Release();
				break;
			}
		}
		return FALSE;

	case IMG :
		IHTMLImgElement* pImgElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLImgElement, (void**)&pImgElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionUnadvise( pImgElem, DIID_HTMLImgEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
			{
				pImgElem->Release();
				break;
			}
		}
		return FALSE;

	case ANCHOR :
		IHTMLAnchorElement *pAnchElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLAnchorElement, (void**)&pAnchElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionUnadvise( pAnchElem, DIID_HTMLAnchorEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
			{
				pAnchElem->Release();
				break;
			}
		}
		return FALSE;

	case SELECT :
		IHTMLSelectElement *pSelElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLSelectElement, (void**)&pSelElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionUnadvise( pSelElem, DIID_HTMLSelectElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
			{
				pSelElem->Release();
				break;
			}
		}
		return FALSE;
		
	case BUTTON :
		IHTMLButtonElement *pBtnElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLButtonElement, (void**)&pBtnElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionUnadvise( pBtnElem, DIID_HTMLButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
			{
				pBtnElem->Release();
				break;
			}
		}
		return FALSE;

	case TEXTAREA :
		IHTMLTextAreaElement *pTxtElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLTextAreaElement, (void**)&pTxtElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionUnadvise( pTxtElem, DIID_HTMLTextContainerEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
			{
				pTxtElem->Release();
				break;
			}
		}
		return FALSE;

	case INPUT :
		MSHTML::IHTMLInputElement *pIptElem;
		hr = m_pDisp->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString strType;			
			pIptElem->get_type( &bstrType );
			strType = bstrType;
			pIptElem->Release();

			if( !strcmp( strType, "text" ) )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionUnadvise( pITxtElem, DIID_HTMLInputTextElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
					{
						pITxtElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "button" ) )
			{
				IHTMLInputButtonElement *pIBtnElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIBtnElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionUnadvise( pIBtnElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
					{
						pIBtnElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "radio" ) )
			{
				IHTMLInputButtonElement *pIRdoElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIRdoElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionUnadvise( pIRdoElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
					{
						pIRdoElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "checkbox" ) )
			{
				IHTMLInputButtonElement *pIChkElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIChkElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionUnadvise( pIChkElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
					{
						pIChkElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "password" ) )
			{
				IHTMLInputButtonElement *pIPswElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputTextElement, (void**)&pIPswElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionUnadvise( pIPswElem, DIID_HTMLInputTextElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
					{
						pIPswElem->Release();
						break;
					}
				}
				return FALSE;
			}
			else
			{
				return FALSE;
			}
		}
		return FALSE;

	default:
		return FALSE;

	}
	return TRUE;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIEView::CHTMLElement& CIEView::CHTMLElement::operator = ( const CIEView::CHTMLElement& elem )
{
	if( this == &elem ){ return *this; }

	m_pBrowser = elem.m_pBrowser;
	m_Type = elem.m_Type;
	m_Id = elem.m_Id;
	m_dwConCookie = elem.m_dwConCookie;
	m_pDisp = elem.m_pDisp;
	m_IsCon = elem.m_IsCon;

	return *this;
}








//
// CIEView
//

const int CIEView::_CLICK = 0;
const int CIEView::_DOUBLECLICK = 1;

BEGIN_MESSAGE_MAP(CIEView,CWebBrowser2 )
	//{{AFX_MSG_MAP(CIEView)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_EVENTSINK_MAP( CIEView, CWebBrowser2 )
	ON_EVENT( CIEView, IDW_IE_VIEW, DISPID_BEFORENAVIGATE2, OnBeforeNavigate, VTS_DISPATCH VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PBOOL )
	ON_EVENT( CIEView, IDW_IE_VIEW, DISPID_DOCUMENTCOMPLETE, OnDocumentComplete, VTS_DISPATCH VTS_PVARIANT )
END_EVENTSINK_MAP()

BEGIN_INTERFACE_MAP( CIEView, CWebBrowser2 )
	INTERFACE_PART( CIEView, DIID_HTMLElementEvents, Dispatch )
	INTERFACE_PART( CIEView, DIID_HTMLWindowEvents, Dispatch )
	INTERFACE_PART( CIEView, DIID_HTMLInputTextElementEvents, Dispatch )
END_INTERFACE_MAP()
	
BEGIN_DISPATCH_MAP( CIEView, CWebBrowser2 )
	DISP_FUNCTION_ID( CIEView, "onclick", DISPID_HTMLELEMENTEVENTS_ONCLICK, OnClick, VT_EMPTY, VTS_NONE )
	DISP_FUNCTION_ID( CIEView, "ondoubleclick", DISPID_HTMLELEMENTEVENTS_ONDBLCLICK, OnDbClick, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "onmouseover", DISPID_HTMLELEMENTEVENTS_ONMOUSEOVER, OnMouseOver, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "onmouseout", DISPID_HTMLELEMENTEVENTS_ONMOUSEOUT, OnMouseOut, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "onmousemove", DISPID_HTMLELEMENTEVENTS_ONMOUSEMOVE, OnMouseMove, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "onkeypress", DISPID_HTMLELEMENTEVENTS_ONKEYPRESS, OnKeyPress, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "onkeyup", DISPID_HTMLELEMENTEVENTS_ONKEYUP, OnKeyUp, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "onkeydown", DISPID_HTMLELEMENTEVENTS_ONKEYDOWN, OnKeyDown, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "ondragstart", DISPID_HTMLELEMENTEVENTS_ONDRAGSTART, OnDragStart, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "ondrop", 0x80010019 /*OLEViewQ*/, OnDrop, VT_EMPTY, VTS_NONE )
//	DISP_FUNCTION_ID( CIEView, "onchange", 0x000003e9 /*OLEView*/, OnTextChange, VT_EMPTY, VTS_NONE )
END_DISPATCH_MAP()

extern CStatusBar *g_pStBar;
extern CInteractionToolView *pIToolView;
CIEView::CIEView() : m_pBrowser( NULL ), m_pHtmlWindow( NULL ), m_pDocument( NULL ), m_pXMLDocument( NULL ), m_ElementList()
{
	CoInitialize( NULL );
	EnableAutomation();
}

CIEView::~CIEView()
{
	ConnectionUnAdvise();

	if( m_pHtmlWindow )
	{
		m_pHtmlWindow->Release();
		m_pDocument->Release();
		m_pBrowser->Release();
	}
}

BOOL CIEView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

BOOL CIEView::PreTranslateMessage( MSG* pMsg )
{
	switch( pMsg->message )
	{
	case WM_TIMER :
		break;
	default:
		break;
	}

	return CWebBrowser2::PreTranslateMessage( pMsg );
}

void CIEView::OnPaint() 
{
	CPaintDC dc(this);
}


BOOL CIEView::Create( CWnd* pParent )
{
	CRect rect;
	pParent->GetClientRect( &rect );

	return CWebBrowser2::Create( NULL, WS_VISIBLE | WS_CHILD, rect, pParent, IDW_IE_VIEW, NULL );
}

void CIEView::OnBeforeNavigate( LPDISPATCH , VARIANT *URL, VARIANT *Flag, VARIANT *TargetName, VARIANT *PostData, VARIANT *Header, BOOL *Cancel )
{
	if( !ConnectionUnAdvise() )
	{
		// error
	}

}

void CIEView::OnDocumentComplete( LPDISPATCH /*lpDisp*/, VARIANT* pURL )
{
	if( !GetInterfaces() )
	{
		// error
	}

	if( !ConnectionAdvise() )
	{
		// error
	}

	m_Target = pURL->bstrVal;
}

BOOL CIEView::GetInterfaces()
{
	HRESULT hr;
	IDispatch *pDisp;

	if ( m_pBrowser != NULL )
	{
		m_pBrowser->Release();
		m_pBrowser = NULL;
	}

	LPUNKNOWN lpUnk = GetControlUnknown();
	if ( lpUnk == NULL )
	{
		return FALSE;
	}

	hr = lpUnk->QueryInterface( IID_IWebBrowser2, (void**)&m_pBrowser );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	if( m_pDocument != NULL )
	{
		m_pDocument->Release();
		m_pDocument = NULL;
	}

	hr = m_pBrowser->get_Document( &pDisp );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	hr = pDisp->QueryInterface( IID_IHTMLDocument2, (void**)&m_pDocument );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	if( m_pHtmlWindow != NULL )
	{
		m_pHtmlWindow->Release();
		m_pHtmlWindow = NULL;
	}

	hr = m_pDocument->get_parentWindow( &m_pHtmlWindow );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}


	return TRUE;
}

BOOL CIEView::ConnectionAdvise()
{
	HRESULT hr;
	IHTMLElementCollection *pColl = NULL;
	long celem;
	int count;

	hr = m_pDocument->get_all( &pColl );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	hr = pColl->get_length( &celem );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	for( count = 0; count < celem; count++ )
	{
		VARIANT varIndex;
		VARIANT var2;
		IDispatch *pDisp;
		CString strTag;

		varIndex.vt = VT_UINT;
		varIndex.lVal = count;
		VariantInit( &var2 );

		hr = pColl->item( varIndex, var2, &pDisp );
		if( !SUCCEEDED( hr ) )
		{
			return FALSE;
		}

		CHTMLElement* pElement = new CHTMLElement( this, pDisp );
		pElement->Connect();
		m_ElementList.push_back( pElement );
	}

	return TRUE;
}

BOOL CIEView::ConnectionUnAdvise()
{
	if( m_ElementList.size() > 0 )
	{
		list < CHTMLElement* > :: iterator ite = m_ElementList.begin();
		while( ite != m_ElementList.end() )
		{
			(*ite)->Disconnect();
			delete (*ite);
			ite++;
		}
		m_ElementList.clear();
	}
	return TRUE;
}

void CIEView::Navigate( LPCSTR strUrl )
{
	COleVariant noArg;
	CWebBrowser2::Navigate( strUrl, noArg, noArg, noArg, noArg );
}

void CIEView::OnEvent( int event )
{
	IHTMLEventObj* pEvent = NULL;
	IHTMLElement* pElem = NULL;
	IHTMLElement* pElem2 = NULL;
	long cx, cy;
	HRESULT hr;
	BSTR bstr_id;
	BSTR bstr_name;

	m_ClickedObj.Empty();
	m_ClickedObjName.Empty();
	hr = m_pHtmlWindow->get_event( &pEvent );
	if( SUCCEEDED( hr ) )
	{
		hr = pEvent->get_srcElement( &pElem );

		hr = pEvent->get_clientX( &cx );
		if( !SUCCEEDED( hr ) ){	cx = -1; }
		hr = pEvent->get_clientY( &cy );
		if( !SUCCEEDED( hr ) ){	cy = -1;}

		if( event == _CLICK )
		{
			do
			{
				pElem2 = pElem;
				pElem2->get_tagName( &bstr_name );
				m_ClickedObjName = bstr_name;
				if(m_ClickedObjName.CompareNoCase("input") == 0)
				{
					MSHTML::IHTMLInputElement *pIptElem;
					hr = pElem2->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
					if( SUCCEEDED( hr ) )
					{
						BSTR bstrType;
						CString strType;			
						pIptElem->get_type( &bstrType );
						strType = bstrType;
						pIptElem->Release();

						if( !strcmp( strType, "text" ) )
							m_ClickedObjName = "text";
					}
				}
				pElem2->get_id( &bstr_id );
				m_ClickedObj = bstr_id;
				pElem = NULL;
				hr = pElem2->get_parentElement( &pElem );
				if( hr != S_OK || pElem == NULL )
				{
					return;
				}
			}while( m_ClickedObj == "" );

			char px[10];
			char py[10];
			ltoa( cx, px, 10 );
			ltoa( cy, py, 10 );
		}
	}
}

void CIEView::OnClick()
{
	OnEvent( _CLICK );
	CString strMsgPath = "id̂interactiontł܂";
	CString strMsgForm = "eLXgGAȊO͑ł܂";
	if(!m_ClickedObj.IsEmpty())
	{
		strMsgPath = m_ClickedObj;
		pIToolView->NotifySelect(m_ClickedObj);
		if(m_ClickedObjName.Compare("text")==0)
		{
			strMsgForm = m_ClickedObj;
			pIToolView->NotifySelectForm(m_ClickedObj,"");
		}
	}
	g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_PATH),strMsgPath);
	g_pStBar->SetPaneText(g_pStBar->CommandToIndex(ID_INDICATOR_FORM),strMsgForm);
}

void CIEView::OnDbClick()
{
	OnEvent( _DOUBLECLICK );
}

CRect CIEView::GetObjectPosition( LPCSTR object )
{
	IHTMLElementCollection *pColl = NULL;
	HRESULT hr;
	long celem;
	int count;
	CRect Posi;

	hr = m_pDocument->get_all( &pColl );
	if( !SUCCEEDED( hr ) )
	{
	}

	hr = pColl->get_length( &celem );
	if( !SUCCEEDED( hr ) )
	{
	}

	for( count = 0; count < celem; count++ )
	{
		VARIANT varIndex;
		VARIANT var2;
		IDispatch *pDisp;
		IHTMLElement *pElem;
		CString strId;
		BSTR bstrId;

		varIndex.vt = VT_UINT;
		varIndex.lVal = count;
		VariantInit( &var2 );

		hr = pColl->item( varIndex, var2, &pDisp );
		if( !SUCCEEDED( hr ) )
		{
		}

		hr = pDisp->QueryInterface( IID_IHTMLElement, (void**)&pElem );
		if( !SUCCEEDED( hr ) )
		{
		}

		hr = pElem->get_id( &bstrId );
		if( !SUCCEEDED( hr ) )
		{
		}
		strId = bstrId;
		if( strcmp( strId, object ) == 0 )
		{
			long pX, pY;
			long pHeight, pWidth;

			pElem->get_offsetLeft( &pX );
			pElem->get_offsetHeight( &pY );
			pElem->get_offsetWidth( &pWidth );
			pElem->get_offsetHeight( &pHeight );

			CRect rect;
			GetWindowRect( &rect );
			Posi.left = rect.left + pX;
			Posi.top = rect.top + pY;
			Posi.right = Posi.left + pWidth;
			Posi.bottom = Posi.top + pHeight;
			return Posi;
		}
		pDisp->Release();
		pElem->Release();
	}
	pColl->Release();
	Posi.left = -1;
	Posi.top = -1;
	Posi.right = -1;
	Posi.bottom = -1;
	return Posi;
}

IHTMLElement* CIEView::GetObject( LPCSTR object )
{
	IHTMLElementCollection *pColl = NULL;
	HRESULT hr;
	long elem_num;

	hr = m_pDocument->get_all( &pColl );
	if( !SUCCEEDED( hr ) )
	{
		return NULL;
	}

	hr = pColl->get_length( &elem_num );
	if( !SUCCEEDED( hr ) )
	{
		return NULL;
	}

	for( int count = 0; count < elem_num; count++ )
	{
		VARIANT varIndex;
		VARIANT var2;
		IDispatch *pDisp;
		IHTMLElement *pElem;
		CString strId;
		BSTR bstrId;

		varIndex.vt = VT_UINT;
		varIndex.lVal = count;
		VariantInit( &var2 );

		hr = pColl->item( varIndex, var2, &pDisp );
		if( !SUCCEEDED( hr ) )
		{
			return NULL;
		}

		hr = pDisp->QueryInterface( IID_IHTMLElement, (void**)&pElem );
		if( !SUCCEEDED( hr ) )
		{
		}

		hr = pElem->get_id( &bstrId );
		if( !SUCCEEDED( hr ) )
		{
		}
		strId = bstrId;
		if( strId == object )
		{
			pDisp->Release();
			return pElem;
		}
		pDisp->Release();
		pElem->Release();
	}
	return NULL;
}


//void CIEView::OnKeyDown()
//{
//}

//void CIEView::OnKeyPress()
//{
//}

//void CIEView::OnKeyUp()
//{
//}

//void CIEView::OnTextChange()
//{
//}

//void CIEView::OnDragStart()
//{
//}

//void CIEView::OnDrop()
//{
//}

//void CIEView::OnMouseMove()
//{
//}

//void CIEView::OnMouseOver()
//{
//}

//void CIEView::OnMouseOut()
//{
//}
